/* Bluefish HTML Editor
 * paths+_state_config.h - generates paths for config session, templates
 * that match the XDG-BASE-DIR spec on Linux
 * $HOME/.bluefish on OSX
 * and something similar on windows
 *
 * Copyright (C) 2000-2025 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PATHS_STATE_CONFIG_H_
#define __PATHS_STATE_CONFIG_H_

GFile *paths_config_gfile();
GFile *paths_session_gfile();
gchar *paths_user_accelmap(void);
gchar *paths_autosavejournaldir_char();
gchar *paths_autosavedir_char(); 
GFile *paths_templatesdir_gfile();
gchar *paths_datadir_char(const gchar *filename); /* used for both plugins, snippets and bflang files */
void paths_create_dirs_and_migrate();

#endif /* __PATHS_STATE_CONFIG_H_ */
